/*
The source code for the iCal Events Dashboard widget, including this file, was
written by Ben Kazez, and unless given explicit permission by Ben Kazez, you may
not redistribute it in any way, including but not limited to: inclusion in other
software products, selling, placing on the web, and any other redistribution.

In addition, you may not reuse the included iCalEventsPlugin without explicit
permission from Ben Kazez.
*/
var updateTimer;
var updateDelay = 600000; // Update in 10 m = 600000 ms
var calendarKey;
var calendarKeys;
var dateRange;
var MAX_EVENT_NAME_LENGTH = 45; //40
var MAX_CALENDAR_NAME_LENGTH = 35; // limit so it looks like a list
var DEBUG_MODE = 0;
var IEPArraySeparator;

function getLocalizedString(key)
{
    try {
        var ret = localizedStrings[key];
        if (ret === undefined) {
            ret = key;
        }
        return ret;
    } catch(ex) {}
    
    return key;
}

function serializeArray(arr)
{
	//alert("joining: " + arr);
	if(arr.length > 0)
		return arr.join(IEPArraySeparator);
	else
		return "";
}

function unserializeArray(string)
{
	//alert("splitting: " + string);
	return string.split(IEPArraySeparator);
}

function setup()
{
	if(!iCalEventsPlugin) {
		alert('Unable to load iCalEventsPlugin');
		document.getElementById('paper').innerHTML = '<p>' + getLocalizedString('Unable to load plugin') + '</p>';
		return false;
	}

	IEPArraySeparator = iCalEventsPlugin.arraySerializerSeparator();

	// Text fields
	document.getElementById('calendarsLabel').innerHTML = getLocalizedString('Calendars:');
	document.getElementById('dateRangePopupLabel').innerHTML = getLocalizedString('Show events happening within the next:');
	document.getElementById('proglogo').innerHTML = "iCal Events 2.0.2"; // not localized
	document.getElementById('newversion').innerHTML = "<span>" + getLocalizedString('Check for new version') + "</span>";
	
	// Load Preferences
	calendarKey = preferenceForKey("calendarKey");
	// Backwards compatibility
	if(calendarKey) {
		calendarKeys = calendarKey
		setPreferenceForKey(null, "calendarKey");
	}
	calendarKeys = preferenceForKey("calendarKeys");
	dateRange = preferenceForKey("dateRange");

	setTimeout('updateData();', 0); // execute in background thread
	return 1;
}

function createKey(key)
{
	return widget.identifier + "-" + key;
}

function datePartEqual(date1, date2) {
	return date1.getFullYear() == date2.getFullYear() &&
		   date1.getMonth() == date2.getMonth() &&
		   date1.getDay() == date2.getDay();
}

function showInIcal(uid) {
	if(window.widget) {
		var c = "/usr/bin/osascript -e 'tell application \"iCal\" to show item 1 of (events of every calendar whose uid is \"" + uid + "\")' ";
		// alert('c: ' + c);
		widget.system(c, null);
		widget.openApplication("com.apple.iCal");
	}
}

var HEX = "0123456789ABCDEF";
function hex2dec(hexIn) { // 2-digit hex only
	hexIn = hexIn.toUpperCase();
	var dec = HEX.indexOf(hexIn[0]) * 16 + HEX.indexOf(hexIn[1]);
	//alert(hexIn + " => " + dec);
	return dec;
}

// color => #e6e6e6 if color > #e6e6e6
function truncateColor(color) {
	//alert("color = " + color);
	var THRESHOLD = 230;
	if((hex2dec(color.substring(1,3)) + hex2dec(color.substring(3,5)) +
		hex2dec(color.substring(5,7))) / 3.0 > THRESHOLD) {
		//alert("=> yes trunc; returning #e6e6e6");
		return "#cfcfcf";
	} else {
		//alert('=> no trunc');
		return color;
	}
}

function truncateString(string, maxLength) {
	if(string.length > maxLength) {
		string = string.substr(0, maxLength) + '...';
	}
	return string;
}

function updateData() {
	var numEvents;
	// alert('Updating data');

	// Get date boundaries (24 hrs into future)
	var lowerDateBound = new Date();
	var upperDateBound = new Date();
	// 24 hours = 86,400,000 milliseconds
	//alert('dateRange = ' + dateRange);
	upperDateBound.setTime(lowerDateBound.getTime() + 86400000 * dateRange);
	// Set upperDateBound to the end of the day so we include all of the last day in the date range
	upperDateBound.setHours(23);
	upperDateBound.setMinutes(59);
	upperDateBound.setSeconds(59);
	upperDateBound.setMilliseconds(999);
	
	// Load events
	//alert('lowerDateBound.getTime() = ' + lowerDateBound.getTime());
	//alert('upperDateBound.getTime() = ' + upperDateBound.getTime());
	
	/****** Display ********/
	
	// Set title bar of widget
	var title = "iCal Events";
	if(calendarKeys.length == 1)
		title += getLocalizedString(": ") + "<span id=\"calendarTitle\">" + iCalEventsPlugin.calendarValueForProperty("Title", iCalEventsPlugin.indexOfCalendarHavingKey(calendarKeys[0])) + "</span>";
	// else multiple calendars or no calendars, so no calendar name

	document.getElementById('header').innerHTML = title;

	// If no calendars checked, return with nice message
	if(calendarKeys.length == 0) {
		paper.innerHTML = "<p>" + getLocalizedString("No calendars selected.") + "</p>";
		// Recalculate scrollbar
		calculateAndShowThumb(document.getElementById('paper'));
		return; // Not an error -- but nothing more to do with display
	}
	// We need to serialize it so it can be passed from JS to ObjC
	if(!iCalEventsPlugin.loadCalendarEventsFromCalendarsWithKeys(serializeArray(calendarKeys), lowerDateBound.getTime(), upperDateBound.getTime()))
		alert('Unable to load calendar events.');

	numEvents = iCalEventsPlugin.numEvents();
	paper = document.getElementById('paper');

	paper.innerHTML = "";
	if(numEvents > 0) {
		// Set "paper" area of calendar
		paper.innerHTML += '<table cellspacing="0" cellpadding="0">';

		var startDate, oldStartDate = new Date(0);
		var summary, eventClassName, parentCalendarKey;

		for(var i = 0; i < numEvents; i++) {
			startDate = new Date(iCalEventsPlugin.eventValueForProperty("DTSTART", i));
			// alert("DTSTART = " + iCalEventsPlugin.eventValueForProperty("DTSTART", i) + "; startDate = " + startDate);

			if(!datePartEqual(startDate, oldStartDate)) {
				// alert(" ");
				// alert(dateFormat(startDate) + " [" + startDate.getFullYear() + "]");
				paper.innerHTML += '<tr><td class="dateHeader" colspan="2">' + iCalEventsPlugin.formattedDateWithMilliseconds(startDate.getTime()) + '</td></tr>';
			}
			
			// Truncate SUMMARY if it's too long
			summary = iCalEventsPlugin.eventValueForProperty("SUMMARY", i);
			summary = truncateString(summary, MAX_EVENT_NAME_LENGTH);
			
			parentCalendarKey = iCalEventsPlugin.eventValueForProperty("X-IEP-CALENDAR-KEY", i);
			eventClassName = "event" + i;
			//alert("eventClassName = " + eventClassName);
			paper.innerHTML += '<tr><td><div class="eventTime">' + iCalEventsPlugin.formattedTimeWithMilliseconds(startDate.getTime()) +
				"</div></td><td><div class=\"calendarColor\" id=\"" + eventClassName + "\"></div>" +
				"</td><td class=\"eventSummary\">" + summary +
				"</td></tr>";


			// Set calendar color square; last two characters of color are unneeded (always FF)
			color = truncateColor(iCalEventsPlugin.calendarValueForProperty("ThemeColor",
					iCalEventsPlugin.indexOfCalendarHavingKey(parentCalendarKey)).substring(0,7));
			//alert("color returned = " + color);

			document.getElementById(eventClassName).style.backgroundColor = color;
		
			oldStartDate = startDate;
		}
		
		paper.innerHTML += '</table>';
	} else {
		// No events
		paper.innerHTML = '<p>' + getLocalizedString('No events today or in the next %i day(s).').replace('%i', dateRange) + '</p>';
	}
	
	//alert("paper.innerHTML = " + paper.innerHTML);
	
	// Recalculate scrollbar
	calculateAndShowThumb(document.getElementById('paper'));

	// Set timer so it updates again
	if(updateTimer != null) {
		clearInterval(updateTimer);
		updateTimer = null;
	}
	updateTimer = setInterval("updateData();", updateDelay);
}



function onhide() {
	clearInterval(updateTimer);
	updateTimer = null;
}

function onshow() {
	// Update now and set timer for future update
	if(DEBUG_MODE == 0)
		setTimeout('updateData();', 0); // execute in background thread
}

function onremove ()
{
	clearInterval(updateTimer);
	updateTimer = null;
	if (window.widget)
	{
		widget.setPreferenceForKey(null, createKey("calendarKey"));
		widget.setPreferenceForKey(null, createKey("calendarKeys"));
		widget.setPreferenceForKey(null, createKey("dateRange"));
	}
}

function gotoURL(URL) {
	if (window.widget)
		widget.openURL(URL);
	else
		window.location = URL;
}

if (window.widget)
{
	widget.onremove = onremove;
	widget.onhide = onhide;
	widget.onshow = onshow;
	// widget.onreceiverequest = receiverequest;
}
